unit uWstrzykiwanieZalenoci;

interface

uses SysUtils;

type
  EWyjtekBrakBroni = class(Exception)
  end;

  IBro = interface
    ['{1B8C95B2-D051-4D93-A3B6-E5B2E67FF089}']
    procedure Uyj;
  end;

  ITarcza= interface
    ['{BE3BBE93-8F06-4BC6-99B7-C6E6CD980893}']
    procedure Uyj;
  end;
// ------------------------------- 1 --------------------------------
{
  TRycerz = class
    private
      FBro: IBro;
    public
      constructor Create(aBro: IBro);
  end;
}

// ------------------------------- 2 --------------------------------

{
type
  TRycerz = class
    private
      FBro: IBro;
    public
      constructor Create(aBro: IBro);
      property Bro: IBro read FBro write FBro;
  end;
}

// ------------------------------- 3 --------------------------------

{
type
  TRycerz = class
  private
    FBro: IBro;
  public
    constructor Create(aBro: IBro);
    procedure Uzbrj(aBro: IBro);
    property Bro: IBro read FBro;
  end;
}

// ------------------------------- 4 --------------------------------
{
type
  TMiecz = class(TInterfacedObject, IBro)
  public
    constructor Create;
    procedure Uyj;
  end;

  TLanca = class(TInterfacedObject, IBro)
  public
    constructor Create;
    procedure Uyj;
  end;

type
  TRycerz = class
  private
    FBro: IBro;
  public
    constructor Create;
    property Bro: IBro read FBro write FBro;
  end;
}

// ------------------------------- 5 --------------------------------
{
type
  TMiecz = class(TInterfacedObject, IBro)
  public
    constructor Create(aStalDamasceska: Boolean);
    procedure Uyj;
  end;
}

// ------------------------------- 6 --------------------------------

type
  TMiecz = class(TInterfacedObject, IBro)
  public
    constructor Create;
    procedure Uyj;
  end;


  TSztylet = class(TInterfacedObject, IBro)
  public
    constructor Create;
    procedure Uyj;
  end;


// ------------------------------- 7 --------------------------------
{
type
  TTarczaZaostrzona = class(TInterfacedObject, IBro, iTarcza)
    procedure Uyj;
    procedure Zaso;
  end;
}

// ------------------------------- 8 --------------------------------
  IWaleczny = interface
    ['{A24A33AD-ADD5-442A-A909-1BF7D3FE0237}']
    procedure Walcz;
  end;

  TRycerz = class(TInterfacedObject, IWaleczny)
  private
    FBro: IBro;
  public
    constructor Create(aBro: IBro);
    procedure Walcz;
  end;

  TKrl = class
  private
    FBro: IBro;
    FImi: string;
  public
    constructor Create(aBro: IBro; aImi: string);
    procedure Walcz;
  end;

implementation

uses
  Spring.Container, Spring.Services;

// ------------------------------- 1 --------------------------------
{
constructor TRycerz.Create(aBro: IBro);
begin
  inherited Create;
  if aBro = nil then
  begin
    raise EWyjtekBrakBroni.Create('Rycerz musi mie bro');
  end;
  FBro := aBro;
end;
}

// ------------------------------- 2 --------------------------------
{
constructor TRycerz.Create(aBro: IBro);
begin
end;
}

// ------------------------------- 3 --------------------------------
{
constructor TRycerz.Create(aBro: IBro);
begin
end;

procedure TRycerz.Uzbrj(aBro: IBro);
begin
end;
}

// ------------------------------- 4 --------------------------------
{
constructor TMiecz.Create;
begin
end;

procedure TMiecz.Uyj;
begin
end;

constructor TLanca.Create;
begin
end;

procedure TLanca.Uyj;
begin
end;

constructor TRycerz.Create;
begin
  inherited Create;
  FBro := TMiecz.Create;
end;

var
  Miecz: IBro;
  Lanca: IBro;
}

// ------------------------------- 5 --------------------------------
{
constructor TMiecz.Create(aStalDamasceska: Boolean);
begin
end;

procedure TMiecz.Uyj;
begin
end;
}

// ------------------------------- 6 --------------------------------

constructor TMiecz.Create;
begin
end;

procedure TMiecz.Uyj;
begin
end;

constructor TSztylet.Create;
begin
end;

procedure TSztylet.Uyj;
begin
end;


// ------------------------------- 7 --------------------------------
{
procedure TTarczaZaostrzona.Uyj;
begin
end;

procedure TTarczaZaostrzona.Zaso;
begin
end;
}

// ------------------------------- 8 --------------------------------
constructor TRycerz.Create(aBro: IBro);
begin
  inherited Create;
  FBro := aBro;
end;

procedure TRycerz.Walcz;
begin
  Write('Rycerz rusza do boju!');
  FBro.Uyj;
end;

constructor TKrl.Create(aBro: IBro; aImi: string);
begin
end;

procedure TKrl.Walcz;
begin
end;

var
  Sztylet: IBro;

procedure RycerzWalczy;
var
  Rycerz: IWaleczny;
begin
  Rycerz := ServiceLocator.GetService<IWaleczny>;
  Rycerz.Walcz;
end;

initialization
  GlobalContainer.Build;

{
  GlobalContainer.RegisterType<TMiecz>.Implements<IBro>;
  Miecz := ServiceLocator.GetService<IBro>;
  Miecz.Uyj;
}

{
  GlobalContainer.RegisterType<TMiecz>.Implements<IBro>('miecz');
  GlobalContainer.RegisterType<TLanca>.Implements<IBro>('lanca');
  Miecz := ServiceLocator.GetService<IBro>('miecz');
  Miecz.Uyj;
  Miecz := ServiceLocator.GetService<IBro>('lanca');
  Miecz.Uyj;
}

{
GlobalContainer.RegisterType<TMiecz>.Implements<IBro>('StalDamasceska')
  .DelegateTo(function: TMiecz
              begin
                Result := TMiecz.Create(True);
              end);
GlobalContainer.RegisterType<TMiecz>.Implements<IBro>('StalZwyka')
  .DelegateTo(function: TMiecz
              begin
                Result := TMiecz.Create(False);
              end);
}

{
  GlobalContainer.RegisterType<TMiecz>.Implements<IBro>('miecz');
  GlobalContainer.RegisterType<TSztylet>.Implements<IBro>('sztylet');
  Sztylet := ServiceLocator.GetService<IBro>;
}

{
  GlobalContainer.RegisterType<TMiecz>.Implements<IBro>('miecz');
  GlobalContainer.RegisterType<TSztylet>.Implements<IBro>('sztylet')
    .AsDefault<IBro>;
  Sztylet := ServiceLocator.GetService<IBro>;
}

{
  GlobalContainer.RegisterType<TTarczaZaostrzona>.Implements<IBro>('tarcza')
    .Implements<ITarcza>('tarcza zaostrzona');
}

  GlobalContainer.RegisterType<TMiecz>.Implements<IBro>('miecz').AsDefault<IBro>;
  GlobalContainer.RegisterType<TSztylet>.Implements<IBro>('sztylet');
  GlobalContainer.RegisterType<TRycerz>.Implements<IWaleczny>.InjectConstructor(['miecz']);

  GlobalContainer.RegisterType<TKrl>.InjectConstructor(['miecz', 'Artur']);

end.
